/*
This software module was originally developed by 
        Hang-Seop Lee (hslee@etri.re.kr), ETRI
        Jung-Chul Lee (jclee@etri.re.kr), ETRI
and edited by Hang-Seop Lee, Jung-Chul Lee of ETRI, 
in the course of development of the MPEG-4.
This software module is an implementation of a part of one or
more MPEG-4 tools as specified by the MPEG-4.
ISO/IEC gives users of the MPEG-4 free license to this                
software module or modifications thereof for use in hardware
or software products claiming conformance to the MPEG-4.
Those intending to use this software module in hardware or software
products are advised that its use may infringe existing patents.
The original developer of this software module and his/her company,
the subsequent editors and their companies, and ISO/IEC have no
liability for use of this software module or modifications thereof
in an implementation.
Copyright is not released for non MPEG-4 conforming
products. ETRI retains full right to use the code for his/her own
purpose, assign or donate the code to a third party and to
inhibit third parties from using the code for non
MPEG-4 conforming products.
This copyright notice must be included in all copies or
derivative works. Copyright (c) 1997.
*/    

// EncoderDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Modeless.h"
#include "EncoderDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern void Encoder(int E_Lang_v, int E_Gender, int E_Gender_v, int E_Age, int E_Age_v, int E_Spch, int E_Spch_v, int E_Proso, int E_Proso_d, int E_Proso_F0, int E_Proso_e, int E_Video, int E_Lip, int E_Trick );


int	nCurrentLip = 1;
/////////////////////////////////////////////////////////////////////////////
// CEncoderDlg dialog


CEncoderDlg::CEncoderDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEncoderDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEncoderDlg)
	//}}AFX_DATA_INIT
	m_pMainDlg = NULL;		
}


CEncoderDlg::CEncoderDlg(CDialog* pDlg)		// modeless constructor
{
	m_pMainDlg = pDlg;
}


BOOL CEncoderDlg::Create()
{
	return CDialog::Create(IDD_ENCODER_DIALOG);
}


CEncoderDlg::~CEncoderDlg()
{

}

void CEncoderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEncoderDlg)
	DDX_Control(pDX, IDC_Video, m_check_video);
	DDX_Control(pDX, IDC_Trick, m_check_trick);
	DDX_Control(pDX, IDC_Sprate, m_check_sprate);
	DDX_Control(pDX, IDC_Prosody, m_check_prosody);
	DDX_Control(pDX, IDC_Gender, m_check_gender);
	DDX_Control(pDX, IDC_Lip, m_check_lip);
	DDX_Control(pDX, IDC_F0, m_check_F0);
	DDX_Control(pDX, IDC_Energy, m_check_energy);
	DDX_Control(pDX, IDC_Duration, m_check_duration);
	DDX_Control(pDX, IDC_Age, m_check_age);
	DDX_Control(pDX, IDC_COMBO_GENDER, m_gender);
	DDX_Control(pDX, IDC_COMBO_RATE, m_speechrate);
	DDX_Control(pDX, IDC_COMBO_LANGUAGE, m_language);
	DDX_Control(pDX, IDC_COMBO_AGE, m_age);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEncoderDlg, CDialog)
	//{{AFX_MSG_MAP(CEncoderDlg)
	ON_BN_CLICKED(ID_Encoding, OnEncoding)
	ON_BN_CLICKED(IDC_Prosody, OnProsody)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEncoderDlg message handlers

BOOL CEncoderDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	MoveWindow(50, 445, 700, 130);

	m_language.SetCurSel(20);
	m_check_gender.SetCheck(1);
	m_gender.SetCurSel(0);
	m_check_age.SetCheck(1);
	m_age.SetCurSel(4);
	m_check_sprate.SetCheck(1);
	m_speechrate.SetCurSel(3);
	m_check_prosody.SetCheck(1);
	m_check_duration.SetCheck(1);
	m_check_energy.SetCheck(0);
	m_check_F0.SetCheck(1);
	m_check_video.SetCheck(1);
	m_check_lip.SetCheck(0);
	m_check_trick.SetCheck(1);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEncoderDlg::OnEncoding() 
{
	// TODO: Add your control notification handler code here
	int	f_lcode_v, f_gen, f_gen_v, f_age, f_age_v;
	int	f_sprate, f_sprate_v, f_pro, f_pro_d, f_pro_f0, f_pro_e;
	int f_video, f_lip,  f_trick;

	f_lcode_v = m_language.GetCurSel();
	f_gen = m_check_gender.GetCheck();
	f_gen_v = m_gender.GetCurSel();
	f_age = m_check_age.GetCheck();
	f_age_v = m_age.GetCurSel();
	f_sprate = m_check_sprate.GetCheck();
	f_sprate_v = m_speechrate.GetCurSel();
	f_pro = m_check_prosody.GetCheck();
	f_pro_d = m_check_duration.GetCheck();
	f_pro_f0 = m_check_F0.GetCheck();
	f_pro_e = m_check_energy.GetCheck();
	f_video = m_check_video.GetCheck();
	f_lip = m_check_lip.GetCheck();
	f_trick = m_check_trick.GetCheck();

	if( f_video == 0 )
		f_lip = 0;
	Encoder(f_lcode_v, f_gen, f_gen_v, f_age,f_age_v,f_sprate, f_sprate_v, f_pro, f_pro_d,f_pro_f0,f_pro_e,f_video,f_lip, f_trick );
	AfxMessageBox( "Encoding Success" );

}

BOOL cur_dur_state, cur_F0_state, cur_eng_state;

void CEncoderDlg::OnProsody() 
{
	// TODO: Add your control notification handler code here
	if( m_check_prosody.GetCheck() == 0 )
	{
		cur_dur_state = m_check_duration.GetCheck();
		m_check_duration.SetCheck(0);
		cur_F0_state = m_check_F0.GetCheck();
		m_check_F0.SetCheck(0);
		cur_eng_state = m_check_energy.GetCheck();
		m_check_energy.SetCheck(0);
	}
}
